### 41.1. 保护敏感端点

如果你的项目中添加的有Spring Security，所有通过HTTP暴露的敏感端点都会受到保护。默认情况下会使用基本认证（basic authentication，用户名为user，密码为应用启动时在控制台打印的密码）。

你可以使用Spring属性改变用户名，密码和访问端点需要的安全角色。例如，你可能会在application.properties中添加下列配置：
```java
security.user.name=admin
security.user.password=secret
management.security.role=SUPERUSER
```

**注**：如果你不使用Spring Security，那你的HTTP端点就被公开暴露，你应该慎重考虑启用哪些端点。具体参考[Section 40.1, “Customizing endpoints”](40.1. Customizing endpoints.md)。
